﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class MinimapConfiguration : ConfigurationElement
{
    public float ZoomedIn { get; private set; }
    public float ZoomedOut { get; private set; }
    public float ZoomAnimationTime { get; private set; }
    public bool IsEnabled { get; private set; }
    public Vector2 DefaultIconRenderSize { get; private set; }
    public Vector2 PlayerIconRenderSize { get; private set; }
    public Vector2 MissionIconRenderSize { get; private set; }
    public Vector2 GarageIconRenderSize { get; private set; }

    public MinimapConfiguration() : base("Minimap")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            ZoomedIn = Convert.ToSingle(configElem.Element("ZoomedIn").Value);
            ZoomedOut = Convert.ToSingle(configElem.Element("ZoomedOut").Value);
            ZoomAnimationTime = Convert.ToSingle(configElem.Element("ZoomAnimationTime").Value);
            IsEnabled = Convert.ToBoolean(configElem.Element("IsEnabled").Value);
            DefaultIconRenderSize = configElem.Element("DefaultIconRenderSize").Value.ToVector2();
            PlayerIconRenderSize = configElem.Element("PlayerIconRenderSize").Value.ToVector2();
            MissionIconRenderSize = configElem.Element("MissionIconRenderSize").Value.ToVector2();
            GarageIconRenderSize = configElem.Element("GarageIconRenderSize").Value.ToVector2();
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing minimap configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
